definition module StdIO

//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdIO contains all definition modules of the Object I/O library.
//	********************************************************************************

import
	StdId,					// The operations that generate identification values
	StdIOCommon,			// Function and type definitions used in the library
	StdMaybe,				// The Maybe data type
	StdPSt,					// Operations on PSt that are not device related
	StdSystem,				// System dependent operations
	
	StdFileSelect,			// File selector dialogues
	
	StdPictureDef,			// Type definitions for picture handling
	StdPicture,				// Picture handling operations
	StdBitmap,				// Defines an instance for drawing bitmaps
	
	StdProcessDef,			// Type definitions for process handling
	StdProcess,				// Process handling operations
	
	StdClipboard,			// Clipboard handling operations
	
	StdControlDef,			// Type definitions for controls
	StdControlClass,		// Standard controls class instances
	StdControlReceiver,		// Receiver controls class instances
	StdControl,				// Control handling operations
	
	StdMenuDef,				// Type definitions for menus
	StdMenuElementClass,	// Standard menus class instances
	StdMenuReceiver,		// Receiver menus class instances
	StdMenuElement,			// Menu element handling operations
	StdMenu,				// Menu handling operations
	
	StdReceiverDef,			// Type definitions for receivers
	StdReceiver,			// Receiver handling operations
	
	StdTimerDef,			// Type definitions for timers
	StdTimerElementClass,	// Standard timer class instances
	StdTimerReceiver,		// Receiver timer class instances
	StdTimer,				// Timer handling operations
	StdTime,				// Time related operations
	
	StdWindowDef,			// Type definitions for windows
	StdWindow,				// Window handling operations

	StdPrint,				// for printing
	StdPrintText			// for printing text
